function ductplot2D(filename,plotconst,pressuredirection)
%pressuredirection = 0 for total, 1 for fwd, -1 for backward
load(filename,'numparams','geomname','geomparams')
if numparams.lightload == false
    load(filename,'Ysfint','Ysfplint')
end

% hold off

geom        = eval(strcat(geomname,'(','geomparams',')'));
geom.inner  = false;
X_func      = geom().X;
Xmn_func    = geom().Xmn;

alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
s_d         = numparams.s_d;
omega       = real(numparams.omega);
modes       = numparams.modes;
mach        = numparams.mach;
beta0       = numparams.beta0;


%% PLOTTING
disp('defining plotting parameters...')
if pressuredirection == -1
    plotparams.pressurelabel = '$$p^-/M$$';
    load(filename,'Pmnint')
    Pchoice = Pmnint;
elseif pressuredirection == 0
    plotparams.pressurelabel = '$$p/M$$';
    load(filename,'Pint')
    Pchoice = Pint;
elseif pressuredirection == 1
    plotparams.pressurelabel = '$$p^+/M$$';
    load(filename,'Pplint')
    Pchoice = Pplint;
else
    plotparams.pressurelabel = '$$p/M$$';
    disp('bad pressure direction')
end
if plotconst == 0
    %real part or absolute value: false is re, true is abs
    absol        = false;
    contours     = true;
    n_contours   = 16; %half
    %framerate, cycles per second, tildes indicate dimensionality
    %(t_end_tilde*fps must be an integer)
    fps         = 30;
    cps         = 1;
    omega_tilde = 2*pi*cps;
    t_end_tilde = 4;
    t_end       = omega_tilde*t_end_tilde/omega;
    %minimum time necessary for plotting; minimum number of frames required
    t_min_tilde = min(t_end_tilde,2*pi/omega_tilde);
    n_frames    = t_min_tilde*fps;
    %point through first cycle at which frames begin, in [-0.5,0.5)
    startfrac   = 0;
    t_grid      = 0 + startfrac*2*pi/omega:omega_tilde/(fps*omega)...
        :t_end -omega_tilde/(fps*omega) + startfrac*2*pi/omega;
    %a-vector with all temporal mode information
    exp_a_grid  = zeros(2*a_mx+1,length(t_grid));
    exp_a_gridq = zeros(2*a_mx+1,length(t_grid));
    for I_t = 1:length(t_grid)
        exp_a_grid(:,I_t) ...
            = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*t_grid(I_t));
        exp_a_gridq(:,I_t) ...
            = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*(t_grid(I_t) ...
            + 0.5*pi/omega));
    end

    n_s     = 200;
    n_x     = 200;
    plotparams.n_s = n_s;
    plotparams.n_x = n_x;
    plotparams.s1   = 0;
    plotparams.s2   = numparams.s_d;

    grids = xsframe(geom,numparams,plotparams,Pchoice);

    xx = grids.xx;
    yy = grids.yy;
    P_a = grids.P_a;

    pp          = zeros(n_x+1,n_s+1,n_frames);


    for I_t = 1:n_frames
        fprintf(1,'frame %2.0f\r', I_t);
        for I_s = 1:n_s+1
            for I_x = 1:n_x+1
                pp(I_x,I_s,I_t) ...
                    = real(P_a((I_s-1)*(n_x+1)+I_x,:)...
                    *exp_a_grid(:,I_t))/mach ...
                    + 1i*real(P_a((I_s-1)*(n_x+1)+I_x,:)...
                    *exp_a_gridq(:,I_t))/mach;
            end
        end
    end


    %% DRAW
    disp('plotting...')
    axis tight
    fig = figure;
    filename ...
        = strcat(pwd,'\DuctAcoustics\plotting\plots\placeholderp2.gif');
    clim manual
    if absol == false
        outerclim = abs(max(abs(pp),[],'all'));
    else
        upperclim = abs(max(pp,[],'all'));
    end
    for I_t = 1:length(t_grid)
        I_tmod ...
            = round(rem(t_grid(I_t),2*pi/omega)*fps*omega/(omega_tilde)+1);
        I_tmod = rem(I_tmod-1,n_frames)+1;
        if absol == false
            plotquantity = real(pp(:,:,I_tmod));
            contourlevels ...
                = -outerclim:2*outerclim/(2*n_contours+1):outerclim;
        else
            plotquantity = abs(pp(:,:,I_tmod));
            contourlevels = 0:upperclim/(2*n_contours+1):upperclim;
        end
        if contours == false
            plot_xs = pcolor(xx,yy,plotquantity);
            set(plot_xs, 'EdgeColor', 'none');
        else
            [~,c] = contourf(xx,yy,plotquantity);
            c.LevelList = contourlevels;
        end
        clim([contourlevels(1),contourlevels(length(contourlevels))]);
        hold on
        plot(xx(1,:),yy(1,:),'LineWidth',2,'Color','k');
        plot(xx(n_x+1,:),yy(n_x+1,:),...
            'LineWidth',2,'Color','k')
        xlabel('$$x$$')
        ylabel('$$y$$')
        C = colorbar;
        C.Label.Interpreter = 'latex';
        C.Label.String = plotparams.pressurelabel;
        C.Label.FontSize = 12;
        % daspect([10/57 16/29 1])
        daspect([1 1 1])
        title(strcat('$$t=$$',...
            sprintf(' %5.3f',omega*t_grid(I_t)/omega_tilde)));
        view(90,-90)
        set_custom_colormap(1);
        drawnow
        [imind,cm] = rgb2ind(frame2im(getframe(fig)),256);
        if I_t == 1
            imwrite(imind,cm,filename,'gif','Loopcount',inf,'DelayTime',...
                1/fps);
        else
            imwrite(imind,cm,filename,'gif','WriteMode','append',...
                'DelayTime',1/fps);
        end
        if fps == 1
            title('')
            exportgraphics(gcf,'stillplaceholderp2.pdf','ContentType',...
                'vector')
        end
    end
elseif plotconst == 3
    %% ADMITTANCE PLOT
    hold off
    n_s = 1000;
    s_grid   = (0:s_d/n_s:s_d);
    S_Y = {s_grid, 1:(2*a_mx+1)*(alpha_mx+1)^2};
    Ysf     = Ysfint(S_Y);
    Ysfpl   = Ysfplint(S_Y);
    Ysf     = reshape(Ysf,[],alpha_mx+1,alpha_mx+1,2*a_mx+1);
    Ysfpl   = reshape(Ysfpl,[],alpha_mx+1,alpha_mx+1,2*a_mx+1);
    index = 2;
    % plot(s_grid,real(Ysf(:,index,index,2*a_mx+1)))
    % hold on
    % plot(s_grid,0*imag(Ysf(:,index,index,2*a_mx+1)))
    Y_anltc = zeros(size(s_grid));
    for I_s = 1:length(s_grid)
        s = s_grid(I_s);
        Y_anltc(I_s) = admittancecalc(s,geom,numparams,pressuredirection);
    end
    xlabel('$$s$$')
    plot(s_grid,real(Ysf(:,index,index,2*a_mx+1)))
    hold on
    plot(s_grid,imag(Ysf(:,index,index,2*a_mx+1)))
    plot(s_grid,real(Y_anltc))
    plot(s_grid,imag(Y_anltc))
    legend('$$\Re(Y_{11})$$','$$\Im(Y_{11})$$',...
        '$$\Re(Y_{11}^+)$$','$$\Im(Y_{11}^+)$$')
elseif plotconst == 4
    %% PRESSURE RMS CENTRELINE PLOT
    set(0,'DefaultAxesFontName','Times')
    set(0,'DefaultAxesFontSize',10)
    widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    figure('units','centimeters','position',[5 -5 widthCM widthCM]);

    disp('summing over modes...')
    hold off
    dot     = ones(2*a_mx+1,1);
    n_s = 1000;
    s   = (0:s_d/n_s:s_d)';
    S_P = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
    P   = Pchoice(S_P);
    Xdenom  = zeros(size(s));
    for I_s = 1:length(s)
        Xdenom(I_s) = 1/sqrt(X_func(s(I_s)));
    end
    P   = reshape(P,[],alpha_mx+1,2*a_mx+1);
    Xdenom  = repmat(Xdenom,1,alpha_mx+1,2*a_mx+1);
    C_alpha     = zeros(size(modes(:,1)))';
    cos_alphaX  = zeros(length(s),length(modes(:,1)));
    for alpha = 0:alpha_mx
        C_alpha(alpha+1) = modes(alpha+1,3);
        for I_s = 1:length(s)
            cos_alphaX(I_s,alpha+1) = cos(alpha*pi*Xmn_func(s(I_s))...
                /X_func(s(I_s)));
        end
    end
    C_alpha = repmat(C_alpha,length(s),1,2*a_mx+1);
    cos_alphaX = repmat(cos_alphaX,1,1,2*a_mx+1);
    alphadot = ones(alpha_mx+1,1);
    P_a   = tensorprod(P.*Xdenom.*C_alpha.*cos_alphaX,alphadot,2,1);
    plot(s,sqrt(2*pi/omega)*sqrt(P_a.*conj(P_a)*dot)/mach)
    hold on
    Pwebs_RMS = zeros(size(s));
    for I_s = 1:length(s)
        Pwebs_RMS(I_s) = RMSWebsterSol2D(s(I_s),geom,numparams,...
            pressuredirection);
    end
    plot(s,Pwebs_RMS/mach);
    xlabel('$$s$$')
    ylabel('$$2\sqrt{\frac{\pi}{\omega}\sum_{a = 1}^\infty|P^a|^2}$$',...
        'Rotation',0,'HorizontalAlignment','right',...
        'VerticalAlignment','middle')
    legend('Linear','Webster')
    exportgraphics(gcf,'stillplaceholderp4.pdf','ContentType','vector')
elseif plotconst == 5
    %% FOURIER COEFFICIENTS BY AMPLITUDE (ALONG CENTRELINE)
    % these are compared with the Blackstock solution

    set(0,'DefaultAxesFontName','Times')
    set(0,'DefaultAxesFontSize',10)
    widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    figure('units','centimeters','position',[5 -5 widthCM widthCM]);

    disp('calculating Blackstock solution...')
    n_s     = 200;
    s       = (0:s_d/n_s:s_d)';
    PBlackstock = zeros(length(s(:,1)),a_mx);
    for I_s = 1:n_s+1
        fprintf(1,'s = %6.3f\r',s(I_s));
        for a = 1:1:min(7,a_mx)
            PBlackstock(I_s,a) = BlackstockAmps(s(I_s),a,numparams);
        end
    end

    disp('summing over modes...')
    S_P     = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
    P       = reshape(Pchoice(S_P),[],alpha_mx+1,2*a_mx+1);
    Xdenom  = zeros(size(s));
    for I_s = 1:length(s)
        Xdenom(I_s) = 1/sqrt(X_func(s(I_s)));
    end
    Xdenom  = repmat(Xdenom,1,alpha_mx+1,2*a_mx+1);
    C_alpha     = zeros(size(modes(:,1)))';
    cos_alphaX  = zeros(length(s),length(modes(:,1)));
    for alpha = 0:alpha_mx
        C_alpha(alpha+1) = modes(alpha+1,3);
        for I_s = 1:length(s)
            cos_alphaX(I_s,alpha+1) = cos(alpha*pi*Xmn_func(s(I_s))...
                /X_func(s));
        end
    end
    C_alpha = repmat(C_alpha,length(s),1,2*a_mx+1);
    cos_alphaX = repmat(cos_alphaX,1,1,2*a_mx+1);
    alphadot = ones(alpha_mx+1,1);
    P_a   = tensorprod(P.*Xdenom.*C_alpha.*cos_alphaX,alphadot,2,1);

    disp('plotting...')
    for a = 1:1:7
        colormat = get(gca,'ColorOrder');
        plot(beta0*mach*omega*s,abs(P_a(:,a_mx+1+a)/mach),'--',...
            'LineWidth',2,'Color',colormat(a,:),'DisplayName',...
            append('$$a =$$ ',string(a)));
        hold on
        plot(beta0*mach*omega*s,PBlackstock(:,a)/mach,'Color',...
            colormat(a,:),'DisplayName',append('$$a =$$ ',...
            string(a),', Blackstock'));
        legend
    end
    xlabel('$$\sigma$$')
    ylabel('$$|P^a|$$')
    exportgraphics(gcf,'placeholderp5.pdf','ContentType','vector')
elseif plotconst == 6
    %% CROSS-SECTIONAL AVERAGE ON OUTLET
    % set(0,'DefaultAxesFontName','Times')
    % set(0,'DefaultAxesFontSize',10)
    % widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    % figure('units','centimeters','position',[5 -5 widthCM widthCM]);

    % s1 = s_d;
    s1 = 4*pi/3;
    t1 = 0;
    n_t = 10000;
    t_end       = 4*pi/omega;
    t_grid      = 0+t1:t_end/n_t:t_end -t_end/n_t + t1;
    exp_a_grid  = zeros(length(t_grid),2*a_mx+1);
    P_alpha_a = reshape(Pchoice({s1,1:(2*a_mx+1)*(alpha_mx+1)}),...
        alpha_mx+1,2*a_mx+1);
    mode_ave = zeros(alpha_mx+1,1);
    for alpha = 0:alpha_mx
        mode_ave(alpha+1) = eq(alpha,0)/X_func(s1);
    end
    p_ave = zeros(n_t,1);
    for I_t = 1:n_t
        exp_a_grid(I_t,:) ...
            = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*t_grid(I_t));
        p_ave(I_t) = exp_a_grid(I_t,:)*P_alpha_a'*mode_ave;
    end

    I_t = 1;
    while abs(p_ave(I_t))/mach > 0.01 && I_t < n_t
        I_t = I_t+1;
    end

    plot(omega*t_grid,real(p_ave)/mach,'DisplayName',...
        'Re$$[\overline{p}(t)]$$')
    % hold on
    % plot(omega*t_grid,imag(p_ave)/mach,'DisplayName',...
    %     'Im$$[\overline{p}_\mathrm{o}(t)]$$')
    % legend
    xticks([0 pi 2*pi 3*pi 4*pi])
    xticklabels({'0','$$\pi$$','$$2\pi$$','$$3\pi$$','$$4\pi$$'})
    xlabel('$$\omega t$$')
    exportgraphics(gcf,'stillplaceholderp6.pdf')
else
    disp('invalid choice of plotconst')
end
end