0;

semilog = true;
%0 is a, 1 is alpha, 2 is p, 3 is q
variable = 1;
if variable == 0
    %% TEMPORAL CONVERGENCE
    refname ...
        = 'planarbend3D_alpha010_a010_omega4.8000_M0.05_s_d04.5815_ptot.mat';
    load(refname,'numparams','geomname','Pint')
    geom            = eval(strcat(geomname,'()'));
    qzvar           = geom().qzvar;
    R_func          = geom().R;
    tau_func        = geom().tau;
    s_o             = geom.L;
    R_o             = R_func(s_o);
    tau_o           = tau_func(s_o);
    aref            = numparams.a_mx;
    apltmin         = 1;
    apltmax         = 10;
    avec            = apltmin:apltmax;
    errorvec_a      = zeros(3,length(avec));
    mach            = numparams.mach;
    s_d             = numparams.s_d;
    omega           = numparams.omega;
    alpha_mx        = numparams.alpha_mx;
    nonlinear       = numparams.nonlinear;
    pfwd            = numparams.pfwd;
    for a = apltmin:apltmax
        fprintf(1,'a = %3.0f\r',a)
        if nonlinear == true
            compname = strcat(geomname,sprintf(...
                '_alpha%03.f_a%03.f_omega%06.4f_M%04.2f_s_d%07.4f',...
                alpha_mx,a,omega,mach,s_d));
        else
            compname = strcat(geomname,sprintf(...
                '_alpha%03.f_a%03.f_omega%06.4f_linear_s_d%07.4f',...
                alpha_mx,a,omega,s_d));
        end
        if pfwd == true
            compname = strcat(compname,'_pfwd');
        else
            compname = strcat(compname,'_ptot');
        end
        if qzvar == true
            compname = strcat(compname,sprintf('_tauR%04.2f',tau_o*R_o));
        end
        compname = strcat(compname,'.mat');
        errorvec_a(:,a-apltmin+1) = convergenceintegrator(geom,compname,...
            numparams,Pint);
    end
    figure
    if semilog == true
        semilogx(avec,log10(errorvec_a(1,:)),'b-o',avec,...
            log10(errorvec_a(2,:)),'r-o',avec,log10(errorvec_a(3,:)),...
            'k-o');
        grid on
        tickspacing = 3;
        xticks(apltmin:tickspacing:floor(apltmax/tickspacing)...
            *tickspacing+1)
        xlabel('a')
    else
        plot(log10(avec),log10(errorvec_a(1,:)),'b-o',log10(avec),...
            log10(errorvec_a(2,:)),'r-o',log10(avec),...
            log10(errorvec_a(3,:)),'k-o')
        xlabel('$$\log_{10}(a)$$')
    end
    legend('$$\epsilon_1$$','$$\epsilon_2$$','$$\epsilon_3$$')
    ylabel('$$\log_{10}($$error$$)$$')
elseif variable == 1
    %% SPATIAL CONVERGENCE
    refname ...
        = 'planarbend3D_alpha020_a001_omega4.8000_linear_s_d04.5815_ptot';
    load(refname,'numparams','geomname','Pint')
    geom            = eval(strcat(geomname,'()'));
     qzvar           = geom().qzvar;
    R_func          = geom().R;
    tau_func        = geom().tau;
    s_o             = geom.L;
    R_o             = R_func(s_o);
    tau_o           = tau_func(s_o);
    nonlinear       = numparams.nonlinear;
    modesref        = numparams.modes;
    p_mx            = max(modesref(:,3));
    q_mx            = max(modesref(:,4));
    alpharef        = numparams.alpha_mx;
    alphapltmin     = 0;
    alphapltmax     = 20;
    alphavec        = alphapltmin+1:alphapltmax+1;
    errorvec_alpha  = zeros(3,length(alphavec));
    mach            = numparams.mach;
    a_mx            = numparams.a_mx;
    s_d             = numparams.s_d;
    omega           = numparams.omega;
    pfwd            = numparams.pfwd;
    for alpha = alphapltmin:alphapltmax
        fprintf(1,'alpha = %3.0f\r',alpha)
        if nonlinear == true
            compname = strcat(geomname,sprintf(...
                '_alpha%03.f_a%03.f_omega%06.4f_M%04.2f_s_d%07.4f',...
                alpha,a_mx,omega,mach,s_d));
        else
            compname = strcat(geomname,sprintf(...
                '_alpha%03.f_a%03.f_omega%06.4f_linear_s_d%07.4f',...
                alpha,a_mx,omega,s_d));
        end
        if pfwd == true
            compname = strcat(compname,'_pfwd');
        else
            compname = strcat(compname,'_ptot');
        end
        if qzvar == true
            compname = strcat(compname,sprintf('_tauR%04.2f',tau_o*R_o));
        end
        compname = strcat(compname,'.mat');
        errorvec_alpha(:,alpha-alphapltmin+1) ...
            = convergenceintegrator(geom,compname,numparams,Pint);
    end
    set(0,'DefaultAxesFontName','Times')
    set(0,'DefaultAxesFontSize',10)
    widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    figure('units','centimeters','position',[5 -5 widthCM 0.5*widthCM]);
    if semilog == true
        semilogx(alphavec,log10(errorvec_alpha(1,:)),'b-o',alphavec,...
            log10(errorvec_alpha(2,:)),'r-o',alphavec,...
            log10(errorvec_alpha(3,:)),'k-o');
        grid on
        tickspacing = 8;
        xticks(alphapltmin+1:tickspacing:floor((alphapltmax+1)...
            /tickspacing)*tickspacing+1)
        xlabel('number of modes')
    else
        plot(log10(alphavec),log10(errorvec_alpha(1,:)),'b-',...
            log10(alphavec),log10(errorvec_alpha(2,:)),'r-',...
            log10(alphavec),log10(errorvec_alpha(3,:)),'k-')
        xlabel('$$\log_{10}(\alpha+1)$$')
    end
    legend('$$\epsilon_1$$','$$\epsilon_2$$','$$\epsilon_3$$')
    ylabel('$$\log_{10}($$error$$)$$')

elseif variable == 2
    %% CIRCUMFERENTIAL CONVERGENCE
    refname =...
        'planarbend_p010_q010_a001_omega4.8000_linear_s_d04.5815_pfwd.mat';
    load(refname,'numparams','geomname','Pint')
    geom            = eval(strcat(geomname,'()'));
    qzvar           = geom().qzvar;
    R_func          = geom().R;
    tau_func        = geom().tau;
    s_o             = geom.L;
    R_o             = R_func(s_o);
    tau_o           = tau_func(s_o);
    nonlinear       = numparams.nonlinear;
    modesref        = numparams.modes;
    pref            = max(modesref(:,3));
    q_mx            = max(modesref(:,4));
    ppltmin         = 0;
    ppltmax         = pref;
    pvec            = ppltmin+1:ppltmax+1;
    errorvec_p      = zeros(3,length(pvec));
    mach            = numparams.mach;
    a_mx            = numparams.a_mx;
    s_d             = numparams.s_d;
    omega           = numparams.omega;
    pfwd            = numparams.pfwd;
    for p = ppltmin:ppltmax
        fprintf(1,'p = %3.0f\r',p)
        if nonlinear == true
            compname = strcat(geomname,sprintf(...
                '_p%03.f_q%03.f_a%03.f_omega%06.4f_M%04.2f_s_d%07.4f',...
                p,q_mx,a_mx,omega,mach,s_d));
        else
            compname = strcat(geomname,sprintf(...
                '_p%03.f_q%03.f_a%03.f_omega%06.4f_linear_s_d%07.4f',...
                p,q_mx,a_mx,omega,s_d));
        end
        if pfwd == true
            compname = strcat(compname,'_pfwd');
        else
            compname = strcat(compname,'_ptot');
        end
        if qzvar == true
            compname = strcat(compname,sprintf('_tauR%04.2f',tau_o*R_o));
        end
        compname = strcat(compname,'.mat');
        errorvec_p(:,p-ppltmin+1) = convergenceintegrator(geom,compname,...
            numparams,Pint);
    end
    figure
    if semilog == true
        semilogx(pvec,log10(errorvec_p(1,:)),'b-o',pvec,...
            log10(errorvec_p(2,:)),'r-o',pvec,log10(errorvec_p(3,:)),...
            'k-o');
        grid on
        tickspacing = 7;
        xticks(ppltmin+1:tickspacing:floor((ppltmax+1)/tickspacing)...
            *tickspacing+1)
        xlabel('$$p+1$$')
    else
        plot(log10(pvec),log10(errorvec_p(1,:)),'b-o',log10(pvec),...
            log10(errorvec_p(2,:)),'r-o',log10(pvec),...
            log10(errorvec_p(3,:)),'k-o')
        xlabel('$$log_{10}(p+1)$$')
    end
    legend('$$\epsilon_1$$','$$\epsilon_2$$','$$\epsilon_3$$')
    ylabel('$$log_{10}($$error$$)$$')
elseif variable == 3
    %% RADIAL CONVERGENCE
    refname =...
        'planarbend_p010_q010_a001_omega4.8000_linear_s_d04.5815_pfwd.mat';
    load(refname,'numparams','Pint')
    geom            = eval(strcat(geomname,'()'));
    qzvar           = geom().qzvar;
    R_func          = geom().R;
    tau_func        = geom().tau;
    s_o             = geom.L;
    R_o             = R_func(s_o);
    tau_o           = tau_func(s_o);
    nonlinear       = numparams.nonlinear;
    modes           = numparams.modes;
    p_mx            = max(modes(:,3));
    qref            = max(modes(:,4));
    qpltmin         = 1;
    qpltmax         = qref;
    qvec            = qpltmin:qpltmax;
    errorvec_q      = zeros(3,length(qvec));
    mach            = numparams.mach;
    a_mx            = numparams.a_mx;
    s_d             = numparams.s_d;
    omega           = numparams.omega;
    pfwd            = numparams.pfwd;
    for q = qpltmin:qpltmax
        fprintf(1,'q = %3.0f\r',q)
        if nonlinear == true
            compname = strcat(geomname,sprintf(...
                '_p%03.f_q%03.f_a%03.f_omega%06.4f_M%04.2f_s_d%07.4f',...
                p_mx,q,a_mx,omega,mach,s_d));
        else
            compname = strcat(geomname,sprintf(...
                '_p%03.f_q%03.f_a%03.f_omega%06.4f_linear_s_d%07.4f',...
                p_mx,q,a_mx,omega,s_d));
        end
        if pfwd == true
            compname = strcat(compname,'_pfwd');
        else
            compname = strcat(compname,'_ptot');
        end
        if qzvar == true
            compname = strcat(compname,sprintf('_tauR%04.2f',tau_o*R_o));
        end
        compname = strcat(compname,'.mat');
        errorvec_q(:,q-qpltmin+1) = convergenceintegrator(geom,compname,...
            numparams,Pint);
    end
    figure
    if semilog == true
        semilogx(qvec,log10(errorvec_q(1,:)),'b-o',qvec,...
            log10(errorvec_q(2,:)),'r-o',qvec,log10(errorvec_q(3,:)),...
            'k-o');
        grid on
        tickspacing = 10;
        xticks(qpltmin:tickspacing:floor(qpltmax/tickspacing)...
            *tickspacing+1)
        xlabel('$$q$$')
    else
        plot(log10(qvec),log10(errorvec_q(1,:)),'b-o',log10(qvec),...
            log10(errorvec_q(2,:)),'r-o',log10(qvec),...
            log10(errorvec_q(3,:)),'k-o');
        xlabel('$$log_{10}(q)$$')
    end
    legend('$$\epsilon_1$$','$$\epsilon_2$$','$$\epsilon_3$$')
    ylabel('$$\log_{10}($$error$$)$$')
end
exportgraphics(gcf,'convergenceplot.pdf')


