function Y = admittancecalc(s,geom,numparams,pressuredirection)

s_o     = geom.L;

X_func  = geom().X;
X_o     = X_func(s_o);
X_i     = X_func(0);
ratio   = X_func(0)/X_o;

mach    = numparams.mach;
omega   = numparams.omega;
pfwd    = numparams.pfwd;
m       = -log(ratio)/(2*s_o);
nu      = sqrt(1 - omega^2/(4*m^2));


sigma   = -pi*exp(-2*m*s)/(2*m*X_i);
sigma_o = -pi*exp(-2*m*s_o)/(2*m*X_i);
sigma_i = -pi/(2*m*X_i);

    function I = exbesseli(nu,sigma)
        if imag(nu) == 0
            I = besseli(nu,sigma);
        else
        % elseif imag(nu) ~= 0 && real(nu) == 0
            alpha = imag(nu);
            I = 1/pi*integral(@(theta) exp(sigma*cos(theta))...
                .*cosh(alpha*theta),0,pi) - 1i*sinh(alpha*pi)/pi...
                *integral(@(t) exp(-sigma.*cosh(t)-1i*alpha.*t),0,Inf);
        % else
        %     disp('nu must be purely real or imaginary')
        end
    end
    function K = exbesselk(nu,sigma)
        if imag(nu) == 0
            K = besselk(nu,sigma);
        else
        % else imag(nu) ~= 0 && real(nu) == 0
            alpha = imag(nu);
            K = integral(@(t) exp(-sigma.*cosh(t)).*cos(alpha.*t),0,Inf);
        % else
        %     disp('nu must be purely real or imaginary')
        end
    end

    function sol1 = f1(nu,sigma)
        sol1 = exbesseli(nu,sigma);
    end
    function sol2 = f2(nu,sigma)
        sol2 = exbesselk(nu,sigma);
    end
    function modsol1 = f1til(nu,sigma)
        if imag(nu) == 0
            modsol1 = sigma*f1(nu+1,sigma) ...
                + (nu+1)*f1(nu,sigma);
        else
            alpha = imag(nu);
            % modsol1 = 1/pi*integral(@(theta) (1 + sigma.*cos(theta))...
            %     .*exp(sigma*cos(theta)).*cosh(alpha*theta),0,pi) ...
            %     - 1i*sinh(alpha*pi)/pi*integral(@(t) (1 -sigma.*cosh(t))...
            %     .*exp(-sigma.*cosh(t)-1i*alpha.*t),0,1000);
            modsol1 = 1/pi*integral(@(theta)exp(sigma.*cos(theta))...
                .*((1 + sigma.*cos(theta)).*cosh(alpha.*theta) ...
                + 1i.*(alpha*cosh(alpha.*theta) ...
                - sigma.*sinh(alpha.*theta).*sin(theta))),0,pi) ...
                - sinh(alpha.*pi)./pi.*integral(@(t)exp(-sigma.*cosh(t) ...
                -1i.*alpha.*t).*(-alpha + 1i*(1 - sigma.*exp(-t))),0,625);
        end
    end
    function modsol2 = f2til(nu,sigma)
        if imag(nu) == 0
            modsol2 = -sigma*f2(nu+1,sigma) + (nu+1)*f2(nu,sigma);
        else
            alpha   = imag(nu);
            phi     = (1 + sigma.^2).^(1/4);
            t0      = asinh(1/sigma);
            modsol2 = integral(@(t) (1 - sigma.*cosh(t))...
                .*exp(-sigma.*cosh(t)).*cos(alpha.*t),0,625);
            % modsol2 = integral(@(t)exp(-sigma.*cosh(t)).*(cos(alpha.*t)...
            %     .*(1 + sigma.*cosh(t)) + 1i*(alpha*cos(alpha.*t)...
            %     + sigma.*sin(alpha.*t).*sinh(t))),0,Inf);
            % modsol2 = integral(@(t)exp(-sigma.*cosh(t)).*cos(alpha.*t)...
            %     .*(1 + 0.5.*sigma.*exp(-t)),0,Inf)...
            %     + (phi + 1./phi)/2.*exp(-phi.^2).*integral(@(y) ...
            %     exp(-y.^2/2).*cos(alpha.*(t0 + y./phi)),-phi.*t0,Inf);
        end
    end



Ypl_o = 1i*exp(-1i*pi/4*(sign(1 - 4*m^2*sigma_o^2/omega^2) + 1))...
    *sqrt(abs(1 - 4*m^2*sigma_o^2/omega^2));
Ypl_i = 1i*exp(-1i*pi/4*(sign(1 - 4*m^2*sigma_i^2/omega^2) + 1))...
    *sqrt(abs(1 - 4*m^2*sigma_i^2/omega^2));
Ypl = 1i*exp(-1i*pi/4*(sign(1 - 4*m^2*sigma^2/omega^2) + 1))...
    *sqrt(abs(1 - 4*m^2*sigma^2/omega^2));


c1 = 1;
c2 = -c1*(f1til(nu,sigma_o) - omega*Ypl_o/(2*1i*m)*f1(nu,sigma_o))...
    /(f2til(nu,sigma_o) - omega*Ypl_o/(2*1i*m)*f2(nu,sigma_o));



P_unnorm = c1*f1(nu,sigma) + c2*f2(nu,sigma);
U_unnorm = 2*1i*m/omega*(c1*f1til(nu,sigma) + c2*f2til(nu,sigma));



P_i_unnorm = c1*f1(nu,sigma_i) + c2*f2(nu,sigma_i);
U_i_unnorm = 2*1i*m/omega*(c1*f1til(nu,sigma_i) + c2*f2til(nu,sigma_i));

Y = U_unnorm/P_unnorm;
Y_i = U_i_unnorm/P_i_unnorm;

Spl_i = (2*Ypl_i)\(Y_i + Ypl_i);
Spl   = (2*Ypl)\(Y + Ypl);
Smn   = -(2*Ypl)\(Y - Ypl);


if pfwd == true
    denom = Spl_i\P_i_unnorm;
else
    denom = P_i_unnorm;
end


% disp([s,Spl])

% disp([Y,Ypl])




if s <= s_o
    if pressuredirection == 1
        PwebsRMS = sqrt(2)*mach*X_i*abs(Spl*P_unnorm/denom);
    elseif pressuredirection == 0
        PwebsRMS = sqrt(2)*mach*X_i*abs(P_unnorm/denom);
    elseif pressuredirection == -1
        PwebsRMS = sqrt(2)*mach*X_i*abs(Smn*P_unnorm/denom);
    end
else
    if pressuredirection == 1 || pressuredirection == 0
        PwebsRMS = mach*sqrt(pi/omega)*exp(-(m/2)*s_o)*nu/denom;
    elseif pressuredirection == -1
        PwebsRMS = 0;
    end
end
% disp([s,Spl,Y,Ypl,Spl*P_unnorm/denom])



end