function Fubinicheck(a,b_mx,sigma0,sigma1)
hold off
dot     = ones(1,2*b_mx+1);
sigma   = sigma0:(sigma1-sigma0)/100:sigma1;
linearterm = zeros(size(sigma));
summand = zeros(2*b_mx+1,length(sigma));
for I_sigma = 1:length(sigma)
    linearterm(I_sigma) = (a-1)*besselj(a,a*sigma(I_sigma)) ...
        - a*sigma(I_sigma)*besselj(a+1,a*sigma(I_sigma));
    for b = 1:b_mx
        if b ~= a
            summand(b_mx+1+b,I_sigma) = a^2/(2*(a - b)*b)...
                *besselj(a - b,(a - b)*sigma(I_sigma))...
                *besselj(b,b*sigma(I_sigma));
        end
        summand(b_mx+1-b,I_sigma) = a^2/(2*(a + b)*(-b))...
                *besselj(a + b,(a + b)*sigma(I_sigma))...
                *besselj(-b,-b*sigma(I_sigma));
    end
end
nonlinearterm = dot*summand;
plot(sigma,linearterm,'DisplayName','Linear Term');
hold on
plot(sigma,nonlinearterm,'DisplayName','Nonlinear Term');
legend
end