function Pblackstock_amp = BlackstockAmps(s,a,numparams)
% pressure amplitude P^a(s) according to the Blackstock solution

mach    = numparams.mach;
omega   = numparams.omega;
beta0   = numparams.beta0;
sigma   = mach*beta0*omega*s;

if sigma <= 1
    Pblackstock_amp = mach/(a*sigma)*abs(besselj(a,a*sigma));
elseif sigma > 1 && sigma <= 6
    [P_sh,Phi_sh] = sincrootfind(sigma);
    Pblackstock_amp = mach/(a*pi)*P_sh + mach/(a*sigma*pi)...
        *integral(@(Phi) cos(a*(Phi - sigma*sin(Phi))),single(Phi_sh),pi);
elseif sigma > 6 && sigma <= 10
    Pblackstock_amp = mach/(a*pi)*sincrootfind(sigma);
else
    Pblackstock_amp = mach/(a*(1 + sigma));
end

end