/* Copyright (C) 2013 E.J. Brambley

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses>.

   Additional permission under GNU GPL version 3 section 7

   If you modify this Program, or any covered work, by linking or
   combining it with D.E. Amos' Algorithm 644
   (http://www.netlib.org/toms/644) (or a modified version of that
   library), containing parts covered by the terms of the ACM Software
   Copyright and License Agreement
   (www.acm.org/publications/policies/softwarecrnotice), the licensors
   of this Program grant you additional permission to convey the
   resulting work.  Corresponding Source for a non-source form of such
   a combination shall include the source code for the parts of
   Algorithm 644 used as well as that of the covered work.
*/

/* 
   This code forms the supplementary material of the publication
   Brambley & Gabard (2014), Journal of Sound and Vibration
   Please acknowledge use of this code by citing that publication.
*/

#include <limits.h>
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


int i1mach_(const int*);
extern int i1mach_(const int* const i)
{
  if (*i == 1)
    return 0;
  else if (*i == 2)
    return 1;
  else if (*i == 3)
    return 0;
  else if (*i == 4)
    return 2;
  else if (*i == 5)
    return (int) (sizeof(int) * 8);
  else if (*i == 6)
    return (int) (sizeof(int) / sizeof(char));
  else if (*i == 7)
    return 2;
  else if (*i == 8)
    return (int) (sizeof(int) * 8) - 1;
  else if (*i == 9)
    return INT_MAX;
  else if (*i == 10)
    return FLT_RADIX;
  else if (*i == 11)
    return FLT_MANT_DIG;
  else if (*i == 12)
    return FLT_MIN_EXP;
  else if (*i == 13)
    return FLT_MAX_EXP;
  else if (*i == 14)
    return DBL_MANT_DIG;
  else if (*i == 15)
    return DBL_MIN_EXP;
  else if (*i == 16)
    return DBL_MAX_EXP;

  fprintf(stderr, "I1MACH -- I OUT OF BOUNDS\n");
  exit(1);
}

float r1mach_(const int*);
extern float r1mach_(const int* const i)
{
  if (*i == 1)
    return FLT_MIN;
  else if (*i == 2)
    return FLT_MAX;
  else if (*i == 3)
    return FLT_EPSILON;
  else if (*i == 4)
    return FLT_EPSILON * FLT_RADIX;
  else if (*i == 5)
    return log10f(FLT_RADIX);

  fprintf(stderr, "R1MACH -- I OUT OF BOUNDS\n");
  exit(1);
}


double d1mach_(const int*);
extern double d1mach_(const int* const i)
{
  if (*i == 1)
    return DBL_MIN;
  else if (*i == 2)
    return DBL_MAX;
  else if (*i == 3)
    return DBL_EPSILON;
  else if (*i == 4)
    return DBL_EPSILON * FLT_RADIX;
  else if (*i == 5)
    return log10f(FLT_RADIX);

  fprintf(stderr, "D1MACH -- I OUT OF BOUNDS\n");
  exit(1);
}
