/* Copyright (C) 2013 E.J. Brambley

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses>.

   Additional permission under GNU GPL version 3 section 7

   If you modify this Program, or any covered work, by linking or
   combining it with D.E. Amos' Algorithm 644
   (http://www.netlib.org/toms/644) (or a modified version of that
   library), containing parts covered by the terms of the ACM Software
   Copyright and License Agreement
   (www.acm.org/publications/policies/softwarecrnotice), the licensors
   of this Program grant you additional permission to convey the
   resulting work.  Corresponding Source for a non-source form of such
   a combination shall include the source code for the parts of
   Algorithm 644 used as well as that of the covered work.

   If you modify this Program, or any covered work, by linking or
   combining it with LAPACK (http://www.netlib.org/lapack) (or a
   modified version of that library), containing parts covered by the
   terms of the LAPACK modified BSD license
   (http://www.netlib.org/lapack/LICENSE.txt), the licensors of this
   Program grant you additional permission to convey the resulting
   work.
*/

/* 
   This code forms the supplementary material of the publication
   Brambley & Gabard (2014), Journal of Sound and Vibration
   Please acknowledge use of this code by citing that publication.
*/

#ifndef EJB_SOLVE_FOR_SURFACE_WAVES
#define EJB_SOLVE_FOR_SURFACE_WAVES

#include <complex.h>

/* Maximum number of surface waves returned */
#define MAX_NUM_SURFACE_WAVES 5

/* Maximum number of surface waves for the modified boundary condition */
#define MAX_NUM_SURFACE_WAVES_MOD 7

/* Solve for the surface waves */
int solve_for_surface_waves(complex double omega, complex double* modes, complex double Z, double M);

/* Solve for the surface waves of the modified boundary condition */
int solve_for_surface_waves_bc(complex double omega, complex double* modes, complex double Z, double M, double d_mass, double d_mom, double d_ke, double d_1);


#endif /* EJB_SOLVE_FOR_SURFACE_WAVES */
